# Hua - A PowerShell Static Content Generator
# Determine paging and create paging data file for index and tagged-with-* pages

# $Author: jeffr $
# $Date: 2024-12-25 08:33:17 -0500 (Wed, 25 Dec 2024) $
# $Revision: 231 $

$entries = Import-Csv -Path $args[0] -Delimiter "," | Sort-Object { [int]($_.ID -replace '\D') } -Descending

$entries_pp = $args[1]
$index_base = [io.path]::GetFileNameWithoutExtension($args[2])
$index_ext = [io.path]::GetExtension($args[2])

$page = 1
$entry_c = 1
$entry_i = 1

if (Test-Path ('.\paging.csv')) {
    Remove-Item .\paging.csv
}

Add-Content paging.csv 'ID,Page,Tags,TW Page'

foreach ($entry in $entries) {
    $ID = $entry.'ID'

    # Skip default article
    if ($ID -eq '000000') { continue }

    # Skip if the content file is missing
	if (-Not (Test-Path (Join-Path -Path $args[3] -ChildPath $entry.'File') -PathType Leaf)) {
		continue
	}

    # Skip empty articles
	if ((Get-Content -Path (Join-Path -Path $args[3] -ChildPath $entry.'File')).length -eq 0) {
		continue
	}

    if ($page -gt 1) {
        $page_fn = "$index_base-$page$index_ext"
    } else {
        $page_fn = "$index_base.html"
    }

    $tags_e = $entry.'Tags'
    Add-Content paging.csv "$ID,$page_fn,$tags_e,"

    $entry_c ++
    if ($entry_c -gt $entries_pp) {
        $page ++
        $entry_c = 1
    }
}

$tag_list = @()
$entries = Import-Csv -Path 'paging.csv' -Delimiter ","
foreach ($entry in $entries) {

    $tw_link = ''
    $tags_e = $entry.'Tags' -split '[|]'

    foreach ($tag_e in $tags_e) {
        $tag_e = $tag_e.replace(' ', '-')
        # New or existing tag?
        if ($tag_list.IndexOf($tag_e) -lt 0) {
            # New tag
            $tag_list += $tag_e # Tag label
            $tag_list += 1      # Tag count
            $tw_link = $tw_link + "tagged-with-$tag_e.html|"
        } else {
            # Existing tag
            $tag_e_i = $tag_list.IndexOf($tag_e) + 1 # Get index of tag count
            $tag_list[$tag_e_i] ++ # Increment count of that tag

            $page_no = $tag_list[$tag_e_i] / $entries_pp # Page (unrounded) on which entry should appear
            $page_no = [Math]::Ceiling($page_no) # Page rounded up

            $tw_link = $tw_link + "tagged-with-$tag_e-$page_no.html|"
            $tw_link = $tw_link.replace('-1.','.')
        }
    }

    # Remove trailing pipe
    $tw_link = $tw_link -replace "\|$",''

    # Append the tagged with filenames
    $paging_e = Get-Content 'paging.csv'
    $paging_e[$lineNumber + $entry_i] += $tw_link
    $paging_e | Set-Content 'paging.csv'
    $entry_i ++
}