#!/usr/bin/bash

# $Author: jeffr $
# $Date: 2025-12-25 14:57:30 -0500 (Thu, 25 Dec 2025) $
# $Revision: 307 $

# Get Hua doc HTML
wget --quiet http://callisto/projects/hua.html

# Remove header
hb=$(grep -n '<header' hua.html | awk -F: '{ print $1  }')
he=$(grep -n '</header' hua.html | awk -F: '{ print $1  }')
sed -i "$hb,$he d" hua.html

# Remove footer
fb=$(grep -n '<footer' hua.html | awk -F: '{ print $1  }')
fe=$(grep -n '</footer' hua.html | awk -F: '{ print $1  }')
sed -i "$fb,$fe d" hua.html

# Produce the PDF
pandoc -f html -t ms hua.html -o Hua.ms
groff -Tps -ms Hua.ms > Hua.ps
ps2pdf Hua.ps Hua.pdf

# Copy the PDF to the appropriate directories
cp Hua.pdf ~/www/projects

# Clean up
rm hua.html Hua.ms Hua.ps

# Create and move the zip package
zip -r --quiet ../Hua.zip * -x "tests/*" "doc.sh"
cd ..
mv Hua.zip ~/www/projects
cd Hua